<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
|--------------------------------------------------------------------------
| File and directory Modes
|--------------------------------------------------------------------------
|
| These prefs are used when checking and setting modes when working
| with the file system.  The defaults are fine on servers with proper
| security, but you may wish (or even need) to change the values in
| certain environments (Apache running a separate process for each
| user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
| always be used to set the mode correctly.
|
*/
define('FILE_READ_MODE', 0644);
define('FILE_WRITE_MODE', 0666);
define('DIR_READ_MODE', 0755);
define('DIR_WRITE_MODE', 0777);

/*
|--------------------------------------------------------------------------
| File Stream Modes
|--------------------------------------------------------------------------
|
| These modes are used when working with fopen()/popen()
|
*/

define('FOPEN_READ',							'rb');
define('FOPEN_READ_WRITE',						'r+b');
define('FOPEN_WRITE_CREATE_DESTRUCTIVE',		'wb'); // truncates existing file data, use with care
define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE',	'w+b'); // truncates existing file data, use with care
define('FOPEN_WRITE_CREATE',					'ab');
define('FOPEN_READ_WRITE_CREATE',				'a+b');
define('FOPEN_WRITE_CREATE_STRICT',				'xb');
define('FOPEN_READ_WRITE_CREATE_STRICT',		'x+b');

/*
|--------------------------------------------------------------------------
| Application Settings
|--------------------------------------------------------------------------
*/

define('APPLICATION_BUILD_VERSION','1.2.0');
define('PORTAL_TITLE_PREFIX', 'VA Direct Project - ');
define('INBOX_DISPLAY_PER_PAGE', '25');
define('ADMINPANEL_DISPLAY_PER_PAGE', '10');
define('ADMINPANEL_LOG_DISPLAY_PER_PAGE', '50');
define('SESSION_TIMEOUT_MINS', '10');
define('CUSTOM_MAILBOX_PREFIX', '[Custom].');
define('GROUP_MAILBOX_PREFIX', 'Public');
define('WARNING_TEXT_TITLE','VA Notice and Consent');
define('WARNING_TEXT',
'<h2>VA NOTICE AND CONSENT BANNER</h2>
<p>VA systems are intended to be used by authorized VA network users for viewing and retrieving information only except as otherwise explicitly authorized for official business and limited personal use under VA policy.</p>
<p>
	Information from this system resides on and transmits through computer systems and networks funded by the VA.
 	All access or use constitutes understanding and acceptance that there is no reasonable expectation of privacy in the use of Government networks or systems.
</p>
<p>All access or use of this system constitutes user understanding and acceptance of these terms and constitutes unconditional consent to review and action including (but not limited to) monitoring recording copying auditing inspecting investigating restricting access blocking  tracking disclosing to authorized personnel or any other authorized actions by all authorized VA and law enforcement personnel.</p>
<p>Unauthorized user attempts or acts to
<ul style="list-style-type: none;">
<li>(1) access upload download change or delete information on this system</li>
<li>(2) modify this system</li>  
<li>(3) deny access to this system</li>
<li>(4) accrue resources for unauthorized use or</li> 
<li>(5) otherwise misuse this system are strictly prohibited.</li>
</ul></p>
<p>Such attempts or acts are subject to action that may result in criminal civil or administrative penalties.</p>');
	
define('MAX_ATTACHMENTS_SIZE', '10'); //given in megabytes

/*
|--------------------------------------------------------------------------
| Application Security Settings
|--------------------------------------------------------------------------
*/
define('USE_CAC_AUTH', FALSE);
define('USE_PIV_AUTH', TRUE);
define('MAX_LOGIN_ATTEMPTS', '7');
define('IS_AJAX', isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest');

/*
|--------------------------------------------------------------------------
| Environment Settings
|--------------------------------------------------------------------------
*/

define('DP_ENVIRONMENT', 'PROD');	

switch(DP_ENVIRONMENT) {

	case 'PROD':
		// PRODUCTION (prod)
		define('ENVIRONMENT_COUNTRY', 'US');
		define('ENVIRONMENT_TIMEZONE','America/New_York');
		define('SMTP_HOSTNAME', 'vadirappprd10.aac.domain');
		define('SMTP_PORT', '25');
		define('SMTP_TIMEOUT', '1');
		define('DIRECT_DOMAIN', 'direct.domain');
		define('DIRECT_USERAGENT', '');
		define('DIRECT_SEND_PROTOCOL', 'smtp');
		define('LDAP_HOSTNAME', 'vadirappprd10.aac.domain');
		define('LDAP_PORT', '389');
		define('LDAP_BASE_DOMAIN', 'dc=direct,dc=va,dc=gov');
		define('LDAP_ROLES_GROUP', 'ou=roles,'.LDAP_BASE_DOMAIN);
		define('LDAP_ADMIN_GROUP1', 'ou=admins,'.LDAP_BASE_DOMAIN);
		define('LDAP_ADMIN_USERNAME', 'cn=admin,'.LDAP_BASE_DOMAIN);
		define('LDAP_ADMIN_PASSWORD', '');
		define('LDAP_SEARCH_USERNAME', 'cn=webmailsearch,'.LDAP_BASE_DOMAIN);
		define('LDAP_SEARCH_PASSWORD', '');
		define('LDAP_ACCOUNTS_DN','ou=accounts,'.LDAP_BASE_DOMAIN);
		define('LDAP_GROUPS_DN','ou=groups,'.LDAP_BASE_DOMAIN);
		define('LDAP_DELETED_ACCOUNTS_DN','ou=deletedaccounts,'.LDAP_BASE_DOMAIN);
		define('LDAP_DELETED_GROUPS_DN','ou=deletedgroups,'.LDAP_BASE_DOMAIN);
		define('LDAP_DISTRUBUTION_LIST_DN','ou=distributionlists,'.LDAP_BASE_DOMAIN);
		define('LDAP_DELETED_DISTRUBUTION_LIST_DN','ou=deleteddistributionlists,'.LDAP_BASE_DOMAIN);
		define('DATABASE_HOSTNAME', 'your_server200.aac.dva.domain\your_server200,1433');
		define('DATABASE_NAME', 'direct');
		define('DATABASE_USERNAME', 'dpi-db');
		define('DATABASE_PASSWORD', '');
		define('DATABASE_DRIVER', 'sqlsrv');
		define('WEBSERVICE_URL', 'http://api.direct.domain');
		define('WEBSERVICE_PUBLIC_KEY', '');
		define('WEBSERVICE_PRIVATE_KEY', '');
		define('WKHTMLTOPDF_EXE_PATH', 'C:\Program Files (x86)\wkhtmltopdf\wkhtmltopdf.exe');
		break;
	
	case 'PREPROD':
		// PREPROD (Preproduction)
		define('ENVIRONMENT_COUNTRY', 'US');
		define('ENVIRONMENT_TIMEZONE','America/New_York');
		define('SMTP_HOSTNAME', 'your_server10.aac.domain');
		define('SMTP_PORT', '25');
		define('SMTP_TIMEOUT', '1');
		define('DIRECT_DOMAIN', 'preprod.direct.domain');
		define('DIRECT_USERAGENT', '');
		define('DIRECT_SEND_PROTOCOL', 'smtp');
		define('LDAP_HOSTNAME', 'ldap://your_server10.aac.domain');
		define('LDAP_PORT', '389');
		define('LDAP_BASE_DOMAIN', 'dc=preprod,dc=direct,dc=va,dc=gov');
		define('LDAP_ROLES_GROUP', 'ou=roles,'.LDAP_BASE_DOMAIN);
		define('LDAP_ADMIN_GROUP1', 'ou=admins,' . LDAP_BASE_DOMAIN);
		define('LDAP_ADMIN_USERNAME', 'cn=admin,' . LDAP_BASE_DOMAIN);
		define('LDAP_ADMIN_PASSWORD', '');
		define('LDAP_SEARCH_USERNAME', 'cn=webmailsearch,' . LDAP_BASE_DOMAIN);
		define('LDAP_SEARCH_PASSWORD', '');
		define('LDAP_ACCOUNTS_DN','ou=accounts,' . LDAP_BASE_DOMAIN);
		define('LDAP_GROUPS_DN','ou=groups,' . LDAP_BASE_DOMAIN);
		define('LDAP_DELETED_ACCOUNTS_DN','ou=deletedaccounts,' . LDAP_BASE_DOMAIN);
		define('LDAP_DELETED_GROUPS_DN','ou=deletedgroups,' . LDAP_BASE_DOMAIN);
		define('LDAP_DISTRUBUTION_LIST_DN','ou=distributionlists,' . LDAP_BASE_DOMAIN);
		define('LDAP_DELETED_DISTRUBUTION_LIST_DN','ou=deleteddistributionlists,' . LDAP_BASE_DOMAIN);
		define('DATABASE_HOSTNAME', 'your_server400.aac.dva.domain\your_server400,1433');
		define('DATABASE_NAME', 'direct');
		define('DATABASE_USERNAME', 'dpi-db');
		define('DATABASE_PASSWORD', '');
		define('DATABASE_DRIVER', 'sqlsrv');
		define('WEBSERVICE_URL', 'http://api.preprod.direct.domain');
		define('WEBSERVICE_PUBLIC_KEY', '');
		define('WEBSERVICE_PRIVATE_KEY', '');
		define('WKHTMLTOPDF_EXE_PATH', 'C:\Program Files (x86)\wkhtmltopdf\wkhtmltopdf.exe');
		break;

}

/* End of file constants.php */
/* Location: ./application/config/constants.php */
